import tkinter
import random


# funkcie z povodneho riesenia
def prazdna():
    siet = []
    for i in range(n):
        siet.append([0] * n)
    return siet


def nahodna():
    siet = []
    for i in range(n):
        siet.append([random.randrange(2) for i in range(n)])
    return siet


def pocet_susedov(r, s):
    pocet = 0
    for i in r - 1, r, r + 1:
        for j in s - 1, s, s + 1:
            if 0 <= i < n and 0 <= j < n:
                pocet += generacia[i][j]
    return pocet - generacia[r][s]


def dalsia_generacia():
    global generacia
    global ktora

    nova = prazdna()

    for i in range(n):
        for j in range(n):
            p = pocet_susedov(i, j)
            if generacia[i][j] == 0:
                if p == 3:
                    nova[i][j] = 1
            elif p == 2 or p == 3:
                nova[i][j] = 1

    generacia = nova
    ktora += 1

    okno.title('Hra Život - generácia #' + str(ktora))
    vykresli_aktualny_stav()

    if bezi:
        platno.after(10, dalsia_generacia)


# funkcie súvisiace s grafickým výstupom
def vytvor_siet_stvorcekov():
    s = []
    for i in range(n):
        s.append([0] * n)
        for j in range(n):
            x, y = d * j + x0, d * i + y0
            s[i][j] = platno.create_rectangle(x, y, x + d, y + d, fill='white', outline='gray')
    return s


def vykresli_aktualny_stav():
    for i in range(n):
        for j in range(n):
            farba = ['white', 'green'][generacia[i][j]]
            platno.itemconfig(stvorceky[i][j], fill=farba)


def klik(event):
    s, r = (event.x - x0) // d, (event.y - y0) // d
    if 0 <= r < n and 0 <= s < n:
        if generacia[r][s] == 0:
            generacia[r][s] = 1
            platno.itemconfig(stvorceky[r][s], fill='green')
        else:
            generacia[r][s] = 0
            platno.itemconfig(stvorceky[r][s], fill='white')


def stop():
    tlacidlo_start.configure(state=tkinter.NORMAL)
    global bezi
    bezi = False


def start():
    tlacidlo_start.configure(state=tkinter.DISABLED)
    global bezi
    bezi = True
    dalsia_generacia()


# globalne premenne
n = 50                  # rozmer siete
ktora = 0               # počítadlo generacií
d, x0, y0 = 8, 5, 5     # veľkosť štvorcového políčka a  ľavý horný roh siete
bezi = False            # True ak simulácia beží, inak False

# vytvorenie GUI
okno = tkinter.Tk()
okno.title('Hra Život - generácia #0')

platno = tkinter.Canvas(okno, width=n * d + 10, height=n * d + 10, bg='lightgreen')
platno.pack()
platno.bind('<Button-1>', klik)

# pridali sme tlačidlá na odštartovanie a zastavenie simulácie
tlacidlo_start = tkinter.Button(okno, text='Štart', command=start)
tlacidlo_start.pack()

tlacidlo_stop = tkinter.Button(okno, text='Stop', command=stop)
tlacidlo_stop.pack()

stvorceky = vytvor_siet_stvorcekov()
generacia = nahodna()   # počiatočnú generáciu môžeme opäť zadávať aj pomocou myši, nemusí byť náhodná
vykresli_aktualny_stav()

# spustenie aplikácie
okno.mainloop()
